﻿Imports System.Data
Imports System.Data.SqlClient
Imports System.Runtime.Serialization

<Serializable()> _
Public Class _BaseBO
    Inherits MicroFour.StrataFrame.Business.BusinessLayer

#Region " Constructors "

	''' <summary>
    ''' Initializes a new instance of the _BaseBO class.
    ''' </summary>
    ''' <remarks></remarks>
    <System.Diagnostics.DebuggerNonUserCodeAttribute()> _
    Public Sub New()
        MyBase.New()
        'This call is required by the Component Designer.
        Me.InitializeComponent()
        '-- Add the necessary handlers
        Me.AddHandlers()
    End Sub

    ''' <summary>
    ''' Initializes a new instance of the _BaseBO class.
    ''' </summary>
    ''' <param name="Container">The IContainer to which this object will be added.</param>
    ''' <remarks></remarks>
    <System.Diagnostics.DebuggerNonUserCodeAttribute()> _
    Public Sub New(ByVal Container As System.ComponentModel.IContainer)
        MyBase.New()
        'This call adds the component to the given container.
        Container.Add(Me)
        'This call is required by the Component Designer.
        Me.InitializeComponent()
        '-- Add the necessary handlers
        Me.AddHandlers()
    End Sub

    ''' <summary>
    ''' Initializes a new instance of the _BaseBO class.
    ''' </summary>
    ''' <param name="info">The SerializationInfo for the object.</param>
    ''' <param name="context">The StreamingContext for the source stream.</param>
    ''' <remarks></remarks>
    Protected Sub New(ByVal info As SerializationInfo, ByVal context As StreamingContext)
        MyBase.New(info, context)
        'This call is required by the Component Designer.
        Me.InitializeComponent()
        '-- Add the necessary handlers
        Me.AddHandlers()
    End Sub
    
    ''' <summary>
    ''' Adds the necessary handlers for the _BaseBO class.
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub AddHandlers()
		AddHandler Me.CheckRulesOnCurrentRow, AddressOf _BaseBO_CheckRulesOnCurrentRow
		AddHandler Me.SetDefaultValues, AddressOf _BaseBO_SetDefaultValues
    End Sub
    
#End Region 

#Region " Data Retrieval Methods "



#End Region

#Region " Event Handlers "

    ''' <summary>
    ''' Checks the business rules on the current row
    ''' </summary>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub _BaseBO_CheckRulesOnCurrentRow(ByVal e As MicroFour.StrataFrame.Business.CheckRulesEventArgs)

    End Sub

    ''' <summary>
    ''' Sets the default values for a new row
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub _BaseBO_SetDefaultValues()

    End Sub

#End Region

#Region "  Public Functions  "

    Public Function GetFieldValueByPrimaryKey(ByVal columnname As String, ByVal primarykey As Integer, ByVal allunidades As Boolean) As String
        '-- establish locals
        Dim cmd As New SqlCommand("select " & columnname & " from " & Me.TableName & _
                                  " where " & Me.PrimaryKeyField & " = @primarykey")
        Dim r As String = ""
        Dim results As Object

        '-- create the parameters
        cmd.Parameters.AddWithValue("@primarykey", primarykey).SqlDbType = SqlDbType.Int
        '-- get the single value
        results = Me.ExecuteScalar(cmd)
        '-- see if a value was retrieved
        If (results IsNot Nothing) AndAlso (results IsNot DBNull.Value) Then
            r = CType(results, String)
        End If

        '-- return the results
        Return r
    End Function

#End Region

End Class
